package gov.va.med.mhv.rxrefill.service.impl;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.converter.MyCompleteMedicationConverter;
import gov.va.med.mhv.rxrefill.dto.MedicationAndSupplimentCriteria;
import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;
import gov.va.med.mhv.rxrefill.dto.MyCompleteMedicationDTO;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.service.MedicationSupplementService;
import gov.va.med.mhv.rxrefill.service.MyCompleteMedicationsService;
import gov.va.med.mhv.rxrefill.service.PharmacyRefillWebService;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MyCompleteMedicationsServiceImpl implements MyCompleteMedicationsService{
	
	@Autowired
	@Qualifier("prService")
	private PharmacyRefillWebService  pharmacyRefillService;
	
	@Autowired
	private MedicationSupplementService  medicationSupplementService;

	@Override
	public List<MyCompleteMedicationDTO> getCompleteMedicationList(	MedicationAndSupplimentCriteria searchCriteria)  throws MHVException {
		List<MyCompleteMedicationDTO> completMedicationList = null;
		ResponseUtil<List<PrescriptionDTO>> prescriptionResponse = null;
		try{
			
			completMedicationList = new ArrayList<MyCompleteMedicationDTO>();
			List<MyCompleteMedicationDTO> vaPrescriptionList =null;
			List<PrescriptionDTO> presclist=null;
			
			prescriptionResponse = pharmacyRefillService.getPrescriptionsHistory(searchCriteria.getUserProfileId());

	        if (!prescriptionResponse.isFailure()) {
	        	presclist = (List<PrescriptionDTO>) prescriptionResponse.getPojoObject();
			}

			if(presclist != null){
				vaPrescriptionList =MyCompleteMedicationConverter.convertVATOMyCompList(presclist);
			}
			List<MedicationHistoryDTO>  historyList = medicationSupplementService.getMedicationsByUserId(searchCriteria.getUserProfileId());
			List<MyCompleteMedicationDTO> nonVAPrescriptionList=null;
			if(historyList != null){
				nonVAPrescriptionList = MyCompleteMedicationConverter.convertMedicationHistoryDTOList(historyList);
			}
			filterSource(completMedicationList,vaPrescriptionList,nonVAPrescriptionList,searchCriteria);
			completMedicationList=filterStatus(completMedicationList,searchCriteria);
			completMedicationList=filterCategory(completMedicationList,searchCriteria);
		
		} catch(Exception e){
			throw new MHVException("An error occurred while getting complete medications list.", e);
		}
		return completMedicationList;
	}

	
	private List<MyCompleteMedicationDTO> filterCategory(List<MyCompleteMedicationDTO> completeMedicationList,
			MedicationAndSupplimentCriteria searchCriteria) {
		List<MyCompleteMedicationDTO> compMedicationList = new ArrayList<MyCompleteMedicationDTO>();
		if(completeMedicationList != null && completeMedicationList.size() > 0){
			if(searchCriteria.getHerbsSuppliments() && searchCriteria.getOtc()
					&& searchCriteria.getOther() && searchCriteria.getRxMedication()){
				compMedicationList=completeMedicationList;
			}else{
				for(MyCompleteMedicationDTO prescDTO:completeMedicationList ){
					if(!searchCriteria.getHerbsSuppliments()){
						if(prescDTO.getCategory().equals("Herbal") || 
						   prescDTO.getCategory().equals("Supplement")	){
						   continue;
						}
					}
					if(!searchCriteria.getOtc()){
						if(prescDTO.getCategory().equals("Over-the-Counter")){
						   continue;
						}
					}
					if(!searchCriteria.getOther()){
						if(prescDTO.getCategory().equals("Other")){
						   continue;
						}
					}
					if(!searchCriteria.getRxMedication()){
						if(prescDTO.getCategory().equals("Rx Medication")){
						   continue;
						}
					}
					compMedicationList.add(prescDTO);
				}
			}
		}
		return compMedicationList;
	}

	private List<MyCompleteMedicationDTO> filterStatus(List<MyCompleteMedicationDTO> completeMedicationList,
			MedicationAndSupplimentCriteria searchCriteria) {
		List<MyCompleteMedicationDTO> compMedicationList = new ArrayList<MyCompleteMedicationDTO>();
		if(completeMedicationList != null && completeMedicationList.size() > 0){
			if(searchCriteria.getStatus().equals("BOTH")){
				compMedicationList=completeMedicationList;
			}else if(searchCriteria.getStatus().equals("ACTIVE")){
				for(MyCompleteMedicationDTO prescDTO:completeMedicationList ){
					if(prescDTO.getDispStatus().equals("Active")){
						compMedicationList.add(prescDTO);
					}
				}
			}else{
				for(MyCompleteMedicationDTO prescDTO:completeMedicationList ){
					if(prescDTO.getDispStatus().equals("Expired") ||
					   prescDTO.getDispStatus().equals("Discontinued")){
						compMedicationList.add(prescDTO);
					}
				}
			}
		}
		return compMedicationList;
	}

	private void filterSource(List<MyCompleteMedicationDTO> completMedicationList,List<MyCompleteMedicationDTO> vaPrescriptionList,
		      	List<MyCompleteMedicationDTO> nonVAPrescriptionList, MedicationAndSupplimentCriteria searchCriteria) {
		
		if(searchCriteria.getSource().equals("BOTH")){
			if(vaPrescriptionList != null){
				completMedicationList.addAll(vaPrescriptionList);
			}
			if(nonVAPrescriptionList != null){
				completMedicationList.addAll(nonVAPrescriptionList);
			}
		}else if(searchCriteria.getSource().equals("VA")){
			if(vaPrescriptionList != null){
				completMedicationList.addAll(vaPrescriptionList);
			}
		}else if(searchCriteria.getSource().equals("NONVA")){
			if(nonVAPrescriptionList != null){
				completMedicationList.addAll(nonVAPrescriptionList);
			}
		}
	}
}
